/*
Easy Bones Creation MacroScript File

 Created:  		April 18 2000

 Author :   Frank DeLise
 Version:  3ds max 4

 IK tools
 This script increases workflow on Bones and IK.
 
 
 Revision History:
 
	11 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macroscript file can be shared with all Discreet products

 
*/
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK



macroScript Bones 
category:~BONES_CATEGORY~ 
internalCategory:"Inverse Kinematics" 
tooltip:~BONES_TOOLTIP~ 
buttontext:~BONES_BUTTONTEXT~ 
Icon:#("MainToolbar",49)
(
    on execute do  StartObjectCreation Bones 
    on isChecked return mcrUtils.IsCreating Bones 
)


MacroScript Auto_Bones
ButtonText:~AUTO_BONES_BUTTONTEXT~
Category:~AUTO_BONES_CATEGORY~ --pfb: 2003.12.11 falls under the animation tools, just like the Bones Tools dialog
internalCategory:"Animation Tools"  --pfb: 2003.12.11 falls under the animation tools, just like the Bones Tools dialog
Tooltip:~AUTO_BONES_TOOLTIP~ 
Icon:#("MainToolbar",49)

(

	On Execute do
	(
		If ABone_Roll != undefined then Try(DestroyDialog ABone_Roll)Catch() 
		Rollout ABone_Roll ~AUTO_BONES_OPTIONS~
		(
			CheckBox ABone_ON ~BONE_ON_OFF~ Across:2 Checked:False Width:~BONE_ON_OFF_WIDTH~
			CheckBox ABone_Auto ~AUTO_ALIGN~ Width:~AUTO_ALIGN_WIDTH~ Across:2 Enabled:False Checked:False
			Button ABone_ReAlign ~REALIGN~ Width:~ABONE_REALIGN_WIDTH~ Align:~ABONE_REALIGN_ALIGN~ offset:~AUTO_BONES_OFFSET~
			Button ABone_ResetStretch ~ABONE_RESETSTRETCH~ Width:~ABONE_RESETSTRETCH_WIDTH~ Align:~ABONE_RESETSTRETCH_ALIGN~ Offset:~ABONE_RESETSTRETCH_OFFSET~ Enabled:False
			CheckBox ABone_Freeze ~ABONE_FREEZE_CAPTION~ Enabled:False Checked:False
			RadioButtons ABone_ScaleType Labels:#(~SCALE~, ~SQUASH~, ~NONE~) Enabled:False columns:~ABONE_SCALETYPE_COLUMNS~
			CheckBox ABone_SLinks ~ABONE_SLINKS~ Across:~ABONE_SLINKS_ACROSS~ Checked:False
			CheckBox ABone_LinksOnly ~ABONE_LINKSONLY~ Across:~ABONE_LINKSONLY_ACROSS~ Checked:False Offset:~ABONE_LINKSONLY_OFFSET~
			Button ABone_Sel ~ABONE_SEL~ Width:~ABONE_SEL_WIDTH~
			Label ABone_1 "----" 
		
			
		
			fn Eval_ABone = 
			(
				Try(
				For i in 1 to Selection.count do
				(
					Selection[i].SetBoneEnable ABone_On.Checked SliderTime
					Selection[i].BoneAutoAlign = ABone_Auto.Checked
					Selection[i].BoneFreezeLength = ABone_Freeze.Checked
					Selection[i].ShowLinks = ABone_SLinks.Checked
					Selection[i].ShowLinksOnly = ABone_LinksOnly.Checked
					
					Case ABone_ScaleType.State of
					(
						1:(Selection[i].BoneScaleType = #Scale)
						2:(Selection[i].BoneScaleType = #Squash) 
						3:(Selection[i].BoneScaleType = #None)  
					)
					ABone_1.text = (~AUTO_BONED~ + i as string + ~OBJECTS~)
				)
				If Selection.Count == 0 then ABone_1.text = (~NO_OBJECTS_SELECTED~)
				)
				Catch()
			) 
			
			On ABone_SLinks Changed State do (Eval_ABone();completeRedraw()  )
			On ABone_LinksOnly Changed State do (Eval_ABone();completeRedraw()  )
			
			On ABone_Sel Pressed Do (Eval_ABone())
			On Abone_On Changed State Do
			(
				ABone_Auto.Enabled = State
				ABone_ResetStretch.Enabled = State
				ABone_Freeze.Enabled = State
				ABone_ScaleType.Enabled = State
				ABone_1.Enabled = State
				Eval_ABone ()
			)
			On ABone_Freeze Changed State Do (Eval_ABone())
			On ABone_ScaleType Changed State Do (Eval_ABone())
			On ABone_Auto Changed State Do (Eval_ABone())
			On ABone_ReAlign Pressed do 
			(	
				For i in 1 to Selection.count do
				(
					Try(
					Selection[i].ReAlignBoneToChild ()
					ABone_1.text = (~REALIGNED~ + i as string + ~ABONE_1_OBJECTS~)
					)Catch()
				)
				If Selection.Count == 0 then ABone_1.text = (~ABONE_1_NO_OBJECTS_SELECTED~)
			)
			On ABone_ResetStretch Pressed do 
			(
				
				For i in 1 to Selection.count do
				(
					Try(
					Selection[i].ResetBoneStretch ()
					ABone_1.text = (~RESET_STRETCH_ON~ + i as string + ~ABONE_1_OBJECTS_CAPTION~)
					)Catch()
				)
				If Selection.Count == 0 then ABone_1.text = (~ABONE_1_NO_OBJECTS_SELECTED_TEXT~)
				
			)
			
			
	)
		CreateDialog ABone_Roll Pos:[150,150] Width:~ABONE_ROLL_WIDTH~ height:~ABONE_ROLL_HEIGHT~
		
	
)

)

